.\"unclutter man
.TH UNCLUTTER 1X
.SH NAME
unclutter \- remove idle cursor image from screen
.SH SYNOPSIS
.B
unclutter
.RB [ -display | -d
.IR display ]
.RB [ -idle
.IR seconds ]
.RB [ -keystroke ]
.RB [ -jitter
.IR pixels ]
.RB [ -grab ]
.RB [ -noevents ]
.RB [ -reset ]
.RB [ -root ]
.RB [ -onescreen ]
.RB [ -not ]
.I "name ...
.SH DESCRIPTION
.B unclutter
removes the cursor image from the screen so that it does not
obstruct the area you are looking at after it has not moved for
a given time.
It does not do this if the cursor is in the root window or a button is down.
It tries to ignore jitter (small movements due to noise)
if you have a mouse that twitches.
.SH OPTIONS
.TP
-display
is followed by the display to open.
.TP
-idle
is followed by the number of seconds between polls for idleness.
The default is 5.
.TP
-keystroke
tells
.B unclutter
not to use a timeout to determine when to remove the cursor, but to
instead wait until a key has been pressed (released, really).
.TP
-jitter
is followed by the amount of movement of the pointer that is to be ignored
and considered as random noise.
The default is 0.
.TP
-grab
means use the original method of grabbing the pointer in order to remove the
cursor. 
This often doesn't interoperate too well with some window managers.
.TP
-noevents
stops unclutter sending a pseudo EnterNotify event to the X client whose
cursor has been stolen.
Sending the event helps programs like emacs think that they have not
lost the pointer focus.
This option is provided for backwards compatibility in case some
clients get upset.
.TP
-reset
resets the timeout for idleness after the cursor is restored for some reason
(such as a window being pushed or popped) even though the x y coordinates
of the cursor have not changed.
Normally, the cursor would immediately be removed again.
.TP
-root
means remove the cursor even if it is on the root background, where in
principle it should not be obscuring anything useful.
.TP
-onescreen
restricts unclutter to the single screen specified as display,
or the default screen for the display.
Normally, unclutter will unclutter all the screens on a display.
.TP
-not
is followed by a list of window names where the cursor should not be
removed.
The first few characters of the WM_NAME property on the window need
to match one the listed names.
This argument must be the last on the command line.
.SH LIMITATIONS
The -keystroke option may not work (that is, the cursor will not
disappear) with clients that request KeyRelease events.
Games and Xt applications using KeyUp in their translation tables are 
most likely to suffer from this problem.
The most feasible solution is to extend unclutter to use the XTest
extension to get all keyboard and mouse events, though this of course
requires XTest to be in the server too.
.PP
The -keystroke option does not distinguish modifier keys from
keys which actually generate characters.
If desired this could be implemented in a simple way by using XLookupString
to see if any characters are returned.
.SH DIAGNOSTICS
The message
.sp
 someone created a sub-window to my sub-window!
.sp 
means that unclutter thinks a second unclutter is running, and tried
to steal the cursor by creating a sub-window to the sub-window already
used to steal the cursor.
This situation quickly deteriorates into a fight no one can win, so
it is detected when possible and the program gives up.
.SH AUTHOR
Mark M Martin. cetia 7feb1994. mmm@cetia.fr
