/*
 * Copyright (C) 2010 Motorola
 * Copyright (C) 2011-2012 Canonical, Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef ANDROID_AUDIO_WRAPPER_H
#define ANDROID_AUDIO_WRAPPER_H

#include <stdint.h>
#include <stddef.h>
#include "android_audio_wrapper_define.h"
//#include <errno.h>
//#ifdef _cplusplus
//extern "C"
//{
//#endif

typedef struct _buffer_struct{
//   enum {
//            MUTE    = 0x00000001
//        };
        uint32_t    flags;
        int         channelCount;
        int         format;
        size_t      frameCount;
        size_t      size;
        union {
            void*       raw;
            short*      i16;
            int8_t*     i8;
        };
}buffer_struct;

/*Audio Track related interface*/
TrackHandle CreateAudioTrack();

void DestoryAudioTrack(TrackHandle handle);

void AudioTrack_start(TrackHandle handle);

void AudioTrack_stop(TrackHandle handle);

status_type AudioTrack_getposition(TrackHandle handle,uint32 *position);

//status_type AudioTrack_setposition(TrackHandle handle,int32_t position);

size_t AudioTrack_write(TrackHandle handle,const void *buffer, size_t size);

status_type AudioTrack_set(TrackHandle handle,stream_type streamtype, uint32 samplerate,audio_format format, audio_channels hannel);

void AudioTrack_pause(TrackHandle handle);

status_type AudioTrack_set_asyn(TrackHandle handle,stream_type streamtype, uint32 samplerate,audio_format format, audio_channels hannel,callback_t cbf,void* user);

uint32 AudioTrack_latency(TrackHandle handle);

void AudioTrack_mute(TrackHandle handle, int muted);

/*Audio Record related interface*/
RecordHandle CreateAudioRecord();

void DestoryAudioRecord(RecordHandle handle);

void AudioRecord_start(RecordHandle handle);

void AudioRecord_stop(RecordHandle handle);

status_type AudioRecord_getposition(RecordHandle handle,int32_t *position);

//status_type AudioRecord_setposition(RecordHandle handle,int32_t position);

size_t AudioRecord_read(RecordHandle handle,void *buffer, size_t size);

status_type AudioRecord_set(RecordHandle handle,audio_source inputsource);

//void AudioRecord_pause(RecordHandle handle);

uint32 AudioRecord_latency(RecordHandle handle);

/*Audio System related interface*/
status_type AudioSystem_getStreamVolumeIndex(stream_type streamtype,int *index );


status_type AudioSystem_getStreamMute(stream_type streamtype, int *mute );


status_type AudioSystem_setStreamVolumeIndex(stream_type streamtype,int index );


status_type AudioSystem_setStreamMute(stream_type streamtype, int mute );

//#ifdef _cplusplus
//}
//#endif

#endif

