// -*- c++ -*-
// Generated by assa-genesis
//------------------------------------------------------------------------------
// $Id: LogMon.cpp,v 1.5 2006/07/20 02:30:55 vlg Exp $
//------------------------------------------------------------------------------
//                            LogMon.cpp
//------------------------------------------------------------------------------
//  Copyright (c) 2003 by Vladislav Grinchenko
//
//  This program is free software; you can redistribute it and/or 
//  modify it under the terms of the GNU General Public License   
//  as published by the Free Software Foundation; either version  
//  2 of the License, or (at your option) any later version.      
//------------------------------------------------------------------------------
//
// Date   : Thu Apr 17 22:49:49 2003
//
//------------------------------------------------------------------------------

#include <assa/INETAddress.h>
#include <assa/TimeVal.h>

#include "LogMon-main.h"
#include "LogMon.h"

// Static declarations mandated by Singleton class
ASSA_DECL_SINGLETON(LogMon);

LogMon::
LogMon () : 
	m_peer (NULL)
{
    // ---Configuration---
    rm_opt ('f', "config-file"  );
    rm_opt ('n', "instance"     );

    // ---Process bookkeeping---
    rm_opt ('b', "daemon"       );
    rm_opt ('l', "pidfile"      );
	rm_opt ('L', "ommit-pidfile");
 
	m_ommit_pidfile = "yes";

    /*---
     * By defauil disable all debugging
     *---*/
    m_mask = ASSA::APP | ASSA::ASSAERR;
    m_log_file = "LogMon.log";
	
	set_port ("assalmon");	// ASSA logging server monitoring port
}

void
LogMon::
init_service ()
{
    trace("LogMon::init_service");

	m_peer = new LogConn;
	ASSA::INETAddress lmon_addr (get_port ().c_str ());

	ASSA::TimeVal timeout (5.0); 
	m_connector.open (timeout, ASSA::async, REACTOR);

	if (m_connector.connect (m_peer, lmon_addr) < 0) {
		DL((ASSA::ASSAERR,"Failed to connect to server\n"));
		stop_service ();
		return;
	}
	
    DL((ASSA::APP,"Service has been initialized\n"));
}

void
LogMon::
process_events ()
{
    trace("LogMon::process_events");

    while (service_is_active ()) {
        m_reactor.waitForEvents ();
    }

    // Shut the service down
    m_reactor.stopReactor ();

    DL((ASSA::APP,"Service stopped!\n"));
}


