#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include "mceliece.h" /* -lmceliece */
#include "limits.inc"

static unsigned char sk[mceliece6688128pc_SECRETKEYBYTES];
static unsigned char c[mceliece6688128pc_CIPHERTEXTBYTES];
static unsigned char k[mceliece6688128pc_BYTES];

static void die_temp(const char *why,const char *why2)
{
  if (why2)
    fprintf(stderr,"mceliece6688128pc-dec: fatal: %s: %s\n",why,why2);
  else
    fprintf(stderr,"mceliece6688128pc-dec: fatal: %s\n",why);
  exit(111);
}

int main()
{
  FILE *skfile;
  FILE *kfile;

  limits();

  skfile = fdopen(8,"r");
  if (!skfile) {
    fprintf(stderr,"mceliece6688128pc-dec: usage: mceliece6688128pc-dec 7>sessionkey <ciphertext 8<secretkey\n");
    die_temp("fdopen 8 failed",strerror(errno));
  }

  kfile = fdopen(7,"w");
  if (!kfile) {
    fprintf(stderr,"mceliece6688128pc-dec: usage: mceliece6688128pc-dec 7>sessionkey <ciphertext 8<secretkey\n");
    die_temp("fdopen 7 failed",strerror(errno));
  }

  if (fread(sk,1,sizeof sk,skfile) < sizeof sk) {
    if (ferror(skfile))
      die_temp("read secretkey failed",strerror(errno));
    die_temp("read secretkey failed","end of file");
  }
  fclose(skfile);

  if (fread(c,1,sizeof c,stdin) < sizeof c) {
    if (ferror(stdin))
      die_temp("read ciphertext failed",strerror(errno));
    die_temp("read ciphertext failed","end of file");
  }
  fclose(stdin);

  if (mceliece6688128pc_dec(k,c,sk)) die_temp("decapsulation failed",0);

  if (fwrite(k,1,sizeof k,kfile) < sizeof k)
    die_temp("write sessionkey failed",strerror(errno));
  if (fflush(kfile))
    die_temp("write sessionkey failed",strerror(errno));
  fclose(kfile);

  return 0;
}
