/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower86@gmail.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/
#include "userlisticonconfigurewgt.h"
#include "userlisticonformat.h"

#include <QGridLayout>

UserListIconConfigureWgt::UserListIconConfigureWgt(QWidget *parent, const UserListIconFormat& fmt)
 :
  QWidget(parent),
  m_format(fmt)
{
  QGridLayout* grid = new QGridLayout(this);

  m_textLab    = new QLabel(this);
  m_totalLab   = new QLabel(this);
  m_genderLab  = new QLabel(this);
  m_statusLab  = new QLabel(this);
  m_avatarLab  = new QLabel(this);

  m_widthLab   = new QLabel(this);
  m_heightLab  = new QLabel(this);
  m_xOffsetLab = new QLabel(this);
  m_yOffsetLab = new QLabel(this);

  m_totalWidthSpbx   = new QSpinBox(this);
  m_totalHeightSpbx  = new QSpinBox(this);

  m_genderWidthSpbx  = new QSpinBox(this);
  m_genderHeightSpbx = new QSpinBox(this);
  m_statusWidthSpbx  = new QSpinBox(this);
  m_statusHeightSpbx = new QSpinBox(this);
  m_avatarWidthSpbx  = new QSpinBox(this);
  m_avatarHeightSpbx = new QSpinBox(this);

  m_genderXSpbx  = new QSpinBox(this);
  m_genderYSpbx  = new QSpinBox(this);
  m_statusXSpbx  = new QSpinBox(this);
  m_statusYSpbx  = new QSpinBox(this);
  m_avatarXSpbx  = new QSpinBox(this);
  m_avatarYSpbx  = new QSpinBox(this);

  m_textEdit     = new QLineEdit(this);

  grid->addWidget(m_widthLab  , 0, 1);
  grid->addWidget(m_heightLab , 0, 2);
  grid->addWidget(m_xOffsetLab, 0, 3);
  grid->addWidget(m_yOffsetLab, 0, 4);

  grid->addWidget(m_totalLab       , 1, 0);
  grid->addWidget(m_totalWidthSpbx , 1, 1);
  grid->addWidget(m_totalHeightSpbx, 1, 2);
//   grid->addWidget(m_totalXSpbx     , 1, 3);
//   grid->addWidget(m_totalYSpbx     , 1, 4);

  grid->addWidget(m_genderLab       , 2, 0);
  grid->addWidget(m_genderWidthSpbx , 2, 1);
  grid->addWidget(m_genderHeightSpbx, 2, 2);
  grid->addWidget(m_genderXSpbx     , 2, 3);
  grid->addWidget(m_genderYSpbx     , 2, 4);

  grid->addWidget(m_statusLab       , 3, 0);
  grid->addWidget(m_statusWidthSpbx , 3, 1);
  grid->addWidget(m_statusHeightSpbx, 3, 2);
  grid->addWidget(m_statusXSpbx     , 3, 3);
  grid->addWidget(m_statusYSpbx     , 3, 4);

  grid->addWidget(m_avatarLab       , 4, 0);
  grid->addWidget(m_avatarWidthSpbx , 4, 1);
  grid->addWidget(m_avatarHeightSpbx, 4, 2);
  grid->addWidget(m_avatarXSpbx     , 4, 3);
//   grid->addWidget(m_avatarYSpbx     , 4, 4);
  m_avatarYSpbx->hide();
//   grid->addWidget(m_genderWidthLab  , 1, 0);
//   grid->addWidget(m_genderWidthSpbx , 1, 1);
//   grid->addWidget(m_genderHeightLab , 1, 2);
//   grid->addWidget(m_genderHeightSpbx, 1, 3);

//   grid->addWidget(m_statusWidthLab  , 2, 0);
//   grid->addWidget(m_statusWidthSpbx , 2, 1);
//   grid->addWidget(m_statusHeightLab , 2, 2);
//   grid->addWidget(m_statusHeightSpbx, 2, 3);

  grid->addWidget(m_textLab , 5, 0);
  grid->addWidget(m_textEdit, 5, 1, 1, 4);

  setFormat(m_format);

  m_textEdit->setToolTip("%nick\n"
                         "%compname\n"
                         "%firstname\n"
                         "%lastname\n"
                         "%secondname\n"
                         "%version\n"
                         "%uid\n"
                         "%ip");

  connect(m_totalWidthSpbx  , SIGNAL(valueChanged(int)), this, SLOT(changeFormat()));
  connect(m_totalHeightSpbx , SIGNAL(valueChanged(int)), this, SLOT(changeFormat()));

  connect(m_genderWidthSpbx , SIGNAL(valueChanged(int)), this, SLOT(changeFormat()));
  connect(m_genderHeightSpbx, SIGNAL(valueChanged(int)), this, SLOT(changeFormat()));
  connect(m_genderXSpbx     , SIGNAL(valueChanged(int)), this, SLOT(changeFormat()));
  connect(m_genderYSpbx     , SIGNAL(valueChanged(int)), this, SLOT(changeFormat()));

  connect(m_statusWidthSpbx , SIGNAL(valueChanged(int)), this, SLOT(changeFormat()));
  connect(m_statusHeightSpbx, SIGNAL(valueChanged(int)), this, SLOT(changeFormat()));
  connect(m_statusXSpbx     , SIGNAL(valueChanged(int)), this, SLOT(changeFormat()));
  connect(m_statusYSpbx     , SIGNAL(valueChanged(int)), this, SLOT(changeFormat()));

  connect(m_avatarWidthSpbx , SIGNAL(valueChanged(int)), this, SLOT(changeFormat()));
  connect(m_avatarHeightSpbx, SIGNAL(valueChanged(int)), this, SLOT(changeFormat()));
  connect(m_avatarXSpbx     , SIGNAL(valueChanged(int)), this, SLOT(changeFormat()));
  connect(m_avatarYSpbx     , SIGNAL(valueChanged(int)), this, SLOT(changeFormat()));
  connect(m_textEdit        , SIGNAL(textChanged (QString)), this, SLOT(changeFormat()));

  retranslate();
}


UserListIconConfigureWgt::~UserListIconConfigureWgt()
{
}

void UserListIconConfigureWgt::changeFormat()
{
  m_format.setText(m_textEdit->text());

  m_format.setTotalWidth   (m_totalWidthSpbx  ->value());
  m_format.setTotalHeight  (m_totalHeightSpbx ->value());

  m_format.setGenderWidth  (m_genderWidthSpbx ->value());
  m_format.setGenderHeight (m_genderHeightSpbx->value());
  m_format.setGenderXoffset(m_genderXSpbx     ->value());
  m_format.setGenderYoffset(m_genderYSpbx     ->value());

  m_format.setStatusWidth  (m_statusWidthSpbx ->value());
  m_format.setStatusHeight (m_statusHeightSpbx->value());
  m_format.setStatusXoffset(m_statusXSpbx     ->value());
  m_format.setStatusYoffset(m_statusYSpbx     ->value());

  m_format.setAvatarWidth  (m_avatarWidthSpbx ->value());
  m_format.setAvatarHeight (m_avatarHeightSpbx->value());
  m_format.setAvatarXoffset(m_avatarXSpbx     ->value());
  m_format.setAvatarYoffset(m_avatarYSpbx     ->value());

  m_statusHeightSpbx ->setMaximum(m_format.totalHeight());
  m_statusYSpbx      ->setMaximum(m_format.totalHeight() - m_format.statusHeight());
  m_statusWidthSpbx  ->setMaximum(m_format.totalWidth());
  m_statusXSpbx      ->setMaximum(m_format.totalWidth() - m_format.statusWidth());

  m_genderHeightSpbx ->setMaximum(m_format.totalHeight());
  m_genderYSpbx      ->setMaximum(m_format.totalHeight() - m_format.genderHeight());
  m_genderWidthSpbx  ->setMaximum(m_format.totalWidth());
  m_genderXSpbx      ->setMaximum(m_format.totalWidth() - m_format.genderWidth());

  m_avatarHeightSpbx ->setMaximum(m_format.totalHeight());
  m_avatarYSpbx      ->setMaximum(m_format.totalHeight() - m_format.avatarHeight());
  m_avatarWidthSpbx  ->setMaximum(m_format.totalWidth());
  m_avatarXSpbx      ->setMaximum(m_format.totalWidth() - m_format.avatarWidth());

  emit formatChanged(m_format);
}

void UserListIconConfigureWgt::retranslate()
{
  m_totalLab  ->setText(tr("Total Size:"));
  m_genderLab ->setText(tr("Gender Icon:"));
  m_statusLab ->setText(tr("Status Icon:"));
  m_avatarLab ->setText(tr("Avatar Icon:"));
  m_textLab   ->setText(tr("Text:"));

  m_widthLab  ->setText(tr("Width"));
  m_heightLab ->setText(tr("Height"));
  m_xOffsetLab->setText(tr("X offset"));
  m_yOffsetLab->setText(tr("Y offset"));
}

void UserListIconConfigureWgt::setFormat(const UserListIconFormat & fmt)
{
  disconnect(m_totalWidthSpbx  , SIGNAL(valueChanged(int)), this, SLOT(changeFormat()));
  disconnect(m_totalHeightSpbx , SIGNAL(valueChanged(int)), this, SLOT(changeFormat()));

  disconnect(m_genderWidthSpbx , SIGNAL(valueChanged(int)), this, SLOT(changeFormat()));
  disconnect(m_genderHeightSpbx, SIGNAL(valueChanged(int)), this, SLOT(changeFormat()));
  disconnect(m_genderXSpbx     , SIGNAL(valueChanged(int)), this, SLOT(changeFormat()));
  disconnect(m_genderYSpbx     , SIGNAL(valueChanged(int)), this, SLOT(changeFormat()));

  disconnect(m_statusWidthSpbx , SIGNAL(valueChanged(int)), this, SLOT(changeFormat()));
  disconnect(m_statusHeightSpbx, SIGNAL(valueChanged(int)), this, SLOT(changeFormat()));
  disconnect(m_statusXSpbx     , SIGNAL(valueChanged(int)), this, SLOT(changeFormat()));
  disconnect(m_statusYSpbx     , SIGNAL(valueChanged(int)), this, SLOT(changeFormat()));

  disconnect(m_avatarWidthSpbx , SIGNAL(valueChanged(int)), this, SLOT(changeFormat()));
  disconnect(m_avatarHeightSpbx, SIGNAL(valueChanged(int)), this, SLOT(changeFormat()));
  disconnect(m_avatarXSpbx     , SIGNAL(valueChanged(int)), this, SLOT(changeFormat()));
  disconnect(m_avatarYSpbx     , SIGNAL(valueChanged(int)), this, SLOT(changeFormat()));

  m_format = fmt;

  m_textEdit->setText(m_format.text());

  m_statusHeightSpbx ->setMaximum(99);
  m_statusYSpbx      ->setMaximum(99);
  m_statusWidthSpbx  ->setMaximum(99);
  m_statusXSpbx      ->setMaximum(99);

  m_genderHeightSpbx ->setMaximum(99);
  m_genderYSpbx      ->setMaximum(99);
  m_genderWidthSpbx  ->setMaximum(99);
  m_genderXSpbx      ->setMaximum(99);

  m_avatarHeightSpbx ->setMaximum(99);
  m_avatarYSpbx      ->setMaximum(99);
  m_avatarWidthSpbx  ->setMaximum(99);
  m_avatarXSpbx      ->setMaximum(99);

  m_totalWidthSpbx  ->setValue(m_format.totalWidth());
  m_totalHeightSpbx ->setValue(m_format.totalHeight());

  m_genderWidthSpbx ->setValue(m_format.genderWidth());
  m_genderHeightSpbx->setValue(m_format.genderHeight());
  m_genderXSpbx     ->setValue(m_format.genderXoffset());
  m_genderYSpbx     ->setValue(m_format.genderYoffset());

  m_statusWidthSpbx ->setValue(m_format.statusWidth());
  m_statusHeightSpbx->setValue(m_format.statusHeight());
  m_statusXSpbx     ->setValue(m_format.statusXoffset());
  m_statusYSpbx     ->setValue(m_format.statusYoffset());

  m_avatarWidthSpbx ->setValue(m_format.avatarWidth());
  m_avatarHeightSpbx->setValue(m_format.avatarHeight());
  m_avatarXSpbx     ->setValue(m_format.avatarXoffset());
  m_avatarYSpbx     ->setValue(m_format.avatarYoffset());

  connect(m_totalWidthSpbx  , SIGNAL(valueChanged(int)), this, SLOT(changeFormat()));
  connect(m_totalHeightSpbx , SIGNAL(valueChanged(int)), this, SLOT(changeFormat()));

  connect(m_genderWidthSpbx , SIGNAL(valueChanged(int)), this, SLOT(changeFormat()));
  connect(m_genderHeightSpbx, SIGNAL(valueChanged(int)), this, SLOT(changeFormat()));
  connect(m_genderXSpbx     , SIGNAL(valueChanged(int)), this, SLOT(changeFormat()));
  connect(m_genderYSpbx     , SIGNAL(valueChanged(int)), this, SLOT(changeFormat()));

  connect(m_statusWidthSpbx , SIGNAL(valueChanged(int)), this, SLOT(changeFormat()));
  connect(m_statusHeightSpbx, SIGNAL(valueChanged(int)), this, SLOT(changeFormat()));
  connect(m_statusXSpbx     , SIGNAL(valueChanged(int)), this, SLOT(changeFormat()));
  connect(m_statusYSpbx     , SIGNAL(valueChanged(int)), this, SLOT(changeFormat()));

  connect(m_avatarWidthSpbx , SIGNAL(valueChanged(int)), this, SLOT(changeFormat()));
  connect(m_avatarHeightSpbx, SIGNAL(valueChanged(int)), this, SLOT(changeFormat()));
  connect(m_avatarXSpbx     , SIGNAL(valueChanged(int)), this, SLOT(changeFormat()));
  connect(m_avatarYSpbx     , SIGNAL(valueChanged(int)), this, SLOT(changeFormat()));

  changeFormat();
}

