/*
 * Copyright (C) 2009  Lorenzo Bettini <http://www.lorenzobettini.it>
 * See COPYING file that comes with this distribution
 */


#ifndef CUSTOMHELPFORM_H
#define CUSTOMHELPFORM_H

#include <QWidget>

namespace Ui {
    class CustomHelpForm;
}

/**
  * A very basic help viewer to be used when qt assistant
  * executable cannot be found.
  */
class CustomHelpForm : public QWidget {
    Q_OBJECT
public:
    CustomHelpForm(QWidget *parent = 0, Qt::WindowFlags f = 0);
    ~CustomHelpForm();

    /**
      * @path the path of the index.html help file
      * @return whether the help file can be open (already
      * shows a warning message).
      */
    bool setHtmlHelpFileDir(const QString &path);

protected:
    void changeEvent(QEvent *e);

private:
    Ui::CustomHelpForm *ui;
};

#endif // CUSTOMHELPFORM_H
